using System;

public class Shape
{
  public virtual void Draw()
  {
    Console.WriteLine("Jestem jakimś kształtem.");
  }
}

public class Circle : Shape
{
  public override void Draw()
  {
    Console.WriteLine("Jestem okręgiem.");
  }
}

public class Rectangle : Shape
{
  public override void Draw()
  {
    Console.WriteLine("Jestem prostokątem.");
  }
}

public class Triangle : Shape
{
  public override void Draw()
  {
    Console.WriteLine("Jestem trójkątem.");
  }
}

public class Program
{
  public static void DrawShape(Shape shape)
  {
    shape.Draw();
  }
  public static void Main()
  {
    Circle circle = new Circle();
    Triangle triangle = new Triangle();
    Rectangle rectangle = new Rectangle();

    DrawShape(circle);
    DrawShape(triangle);
    DrawShape(rectangle);
  }
}
